package zio.aws.sns.model
import zio.aws.sns.model.primitives.TopicARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetDataProtectionPolicyRequest(resourceArn: TopicARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.GetDataProtectionPolicyRequest = {
    import GetDataProtectionPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.GetDataProtectionPolicyRequest
      .builder()
      .resourceArn(TopicARN.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.GetDataProtectionPolicyRequest.ReadOnly =
    zio.aws.sns.model.GetDataProtectionPolicyRequest.wrap(buildAwsValue())
}
object GetDataProtectionPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.GetDataProtectionPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.GetDataProtectionPolicyRequest =
      zio.aws.sns.model.GetDataProtectionPolicyRequest(resourceArn)
    def resourceArn: TopicARN
    def getResourceArn: ZIO[Any, Nothing, TopicARN] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.GetDataProtectionPolicyRequest
  ) extends zio.aws.sns.model.GetDataProtectionPolicyRequest.ReadOnly {
    override val resourceArn: TopicARN =
      zio.aws.sns.model.primitives.TopicARN(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.GetDataProtectionPolicyRequest
  ): zio.aws.sns.model.GetDataProtectionPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
