package zio.aws.sns.model
import zio.aws.sns.model.primitives.AttributeValue
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetDataProtectionPolicyResponse(
    dataProtectionPolicy: Optional[AttributeValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.GetDataProtectionPolicyResponse = {
    import GetDataProtectionPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.GetDataProtectionPolicyResponse
      .builder()
      .optionallyWith(
        dataProtectionPolicy.map(value =>
          AttributeValue.unwrap(value): java.lang.String
        )
      )(_.dataProtectionPolicy)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.GetDataProtectionPolicyResponse.ReadOnly =
    zio.aws.sns.model.GetDataProtectionPolicyResponse.wrap(buildAwsValue())
}
object GetDataProtectionPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.GetDataProtectionPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.GetDataProtectionPolicyResponse =
      zio.aws.sns.model.GetDataProtectionPolicyResponse(
        dataProtectionPolicy.map(value => value)
      )
    def dataProtectionPolicy: Optional[AttributeValue]
    def getDataProtectionPolicy: ZIO[Any, AwsError, AttributeValue] =
      AwsError.unwrapOptionField("dataProtectionPolicy", dataProtectionPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.GetDataProtectionPolicyResponse
  ) extends zio.aws.sns.model.GetDataProtectionPolicyResponse.ReadOnly {
    override val dataProtectionPolicy: Optional[AttributeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataProtectionPolicy())
        .map(value => zio.aws.sns.model.primitives.AttributeValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.GetDataProtectionPolicyResponse
  ): zio.aws.sns.model.GetDataProtectionPolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
