package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetEndpointAttributesRequest(endpointArn: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.GetEndpointAttributesRequest = {
    import GetEndpointAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.GetEndpointAttributesRequest
      .builder()
      .endpointArn(endpointArn: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.GetEndpointAttributesRequest.ReadOnly =
    zio.aws.sns.model.GetEndpointAttributesRequest.wrap(buildAwsValue())
}
object GetEndpointAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.GetEndpointAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.GetEndpointAttributesRequest =
      zio.aws.sns.model.GetEndpointAttributesRequest(endpointArn)
    def endpointArn: String
    def getEndpointArn: ZIO[Any, Nothing, String] = ZIO.succeed(endpointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.GetEndpointAttributesRequest
  ) extends zio.aws.sns.model.GetEndpointAttributesRequest.ReadOnly {
    override val endpointArn: String = impl.endpointArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.GetEndpointAttributesRequest
  ): zio.aws.sns.model.GetEndpointAttributesRequest.ReadOnly = new Wrapper(impl)
}
