package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetPlatformApplicationAttributesRequest(
    platformApplicationArn: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.GetPlatformApplicationAttributesRequest = {
    import GetPlatformApplicationAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.GetPlatformApplicationAttributesRequest
      .builder()
      .platformApplicationArn(platformApplicationArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sns.model.GetPlatformApplicationAttributesRequest.ReadOnly =
    zio.aws.sns.model.GetPlatformApplicationAttributesRequest
      .wrap(buildAwsValue())
}
object GetPlatformApplicationAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.GetPlatformApplicationAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.GetPlatformApplicationAttributesRequest =
      zio.aws.sns.model
        .GetPlatformApplicationAttributesRequest(platformApplicationArn)
    def platformApplicationArn: String
    def getPlatformApplicationArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(platformApplicationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.GetPlatformApplicationAttributesRequest
  ) extends zio.aws.sns.model.GetPlatformApplicationAttributesRequest.ReadOnly {
    override val platformApplicationArn: String =
      impl.platformApplicationArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.GetPlatformApplicationAttributesRequest
  ): zio.aws.sns.model.GetPlatformApplicationAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
