package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPlatformApplicationAttributesResponse(
    attributes: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.GetPlatformApplicationAttributesResponse = {
    import GetPlatformApplicationAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.GetPlatformApplicationAttributesResponse
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly
      : zio.aws.sns.model.GetPlatformApplicationAttributesResponse.ReadOnly =
    zio.aws.sns.model.GetPlatformApplicationAttributesResponse
      .wrap(buildAwsValue())
}
object GetPlatformApplicationAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.GetPlatformApplicationAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.GetPlatformApplicationAttributesResponse =
      zio.aws.sns.model.GetPlatformApplicationAttributesResponse(
        attributes.map(value => value)
      )
    def attributes: Optional[Map[String, String]]
    def getAttributes: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.GetPlatformApplicationAttributesResponse
  ) extends zio.aws.sns.model.GetPlatformApplicationAttributesResponse.ReadOnly {
    override val attributes: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.GetPlatformApplicationAttributesResponse
  ): zio.aws.sns.model.GetPlatformApplicationAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
