package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetSmsAttributesRequest(
    attributes: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.GetSmsAttributesRequest = {
    import GetSmsAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.GetSmsAttributesRequest
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.GetSmsAttributesRequest.ReadOnly =
    zio.aws.sns.model.GetSmsAttributesRequest.wrap(buildAwsValue())
}
object GetSmsAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.GetSmsAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.GetSmsAttributesRequest =
      zio.aws.sns.model.GetSmsAttributesRequest(attributes.map(value => value))
    def attributes: Optional[List[String]]
    def getAttributes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.GetSmsAttributesRequest
  ) extends zio.aws.sns.model.GetSmsAttributesRequest.ReadOnly {
    override val attributes: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.attributes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.GetSmsAttributesRequest
  ): zio.aws.sns.model.GetSmsAttributesRequest.ReadOnly = new Wrapper(impl)
}
