package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetSmsAttributesResponse(
    attributes: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.GetSmsAttributesResponse = {
    import GetSmsAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.GetSmsAttributesResponse
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.GetSmsAttributesResponse.ReadOnly =
    zio.aws.sns.model.GetSmsAttributesResponse.wrap(buildAwsValue())
}
object GetSmsAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.GetSmsAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.GetSmsAttributesResponse =
      zio.aws.sns.model.GetSmsAttributesResponse(attributes.map(value => value))
    def attributes: Optional[Map[String, String]]
    def getAttributes: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.GetSmsAttributesResponse
  ) extends zio.aws.sns.model.GetSmsAttributesResponse.ReadOnly {
    override val attributes: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.GetSmsAttributesResponse
  ): zio.aws.sns.model.GetSmsAttributesResponse.ReadOnly = new Wrapper(impl)
}
