package zio.aws.sns.model
import zio.aws.sns.model.primitives.SubscriptionARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetSubscriptionAttributesRequest(
    subscriptionArn: SubscriptionARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesRequest = {
    import GetSubscriptionAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesRequest
      .builder()
      .subscriptionArn(
        SubscriptionARN.unwrap(subscriptionArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sns.model.GetSubscriptionAttributesRequest.ReadOnly =
    zio.aws.sns.model.GetSubscriptionAttributesRequest.wrap(buildAwsValue())
}
object GetSubscriptionAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.GetSubscriptionAttributesRequest =
      zio.aws.sns.model.GetSubscriptionAttributesRequest(subscriptionArn)
    def subscriptionArn: SubscriptionARN
    def getSubscriptionArn: ZIO[Any, Nothing, SubscriptionARN] =
      ZIO.succeed(subscriptionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesRequest
  ) extends zio.aws.sns.model.GetSubscriptionAttributesRequest.ReadOnly {
    override val subscriptionArn: SubscriptionARN =
      zio.aws.sns.model.primitives.SubscriptionARN(impl.subscriptionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesRequest
  ): zio.aws.sns.model.GetSubscriptionAttributesRequest.ReadOnly = new Wrapper(
    impl
  )
}
