package zio.aws.sns.model
import zio.aws.sns.model.primitives.{AttributeValue, AttributeName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetSubscriptionAttributesResponse(
    attributes: Optional[Map[AttributeName, AttributeValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesResponse = {
    import GetSubscriptionAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesResponse
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.GetSubscriptionAttributesResponse.ReadOnly =
    zio.aws.sns.model.GetSubscriptionAttributesResponse.wrap(buildAwsValue())
}
object GetSubscriptionAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.GetSubscriptionAttributesResponse =
      zio.aws.sns.model
        .GetSubscriptionAttributesResponse(attributes.map(value => value))
    def attributes: Optional[Map[AttributeName, AttributeValue]]
    def getAttributes: ZIO[Any, AwsError, Map[AttributeName, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesResponse
  ) extends zio.aws.sns.model.GetSubscriptionAttributesResponse.ReadOnly {
    override val attributes: Optional[Map[AttributeName, AttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sns.model.primitives.AttributeName(
                key
              ) -> zio.aws.sns.model.primitives.AttributeValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesResponse
  ): zio.aws.sns.model.GetSubscriptionAttributesResponse.ReadOnly = new Wrapper(
    impl
  )
}
