package zio.aws.sns.model
import zio.aws.sns.model.primitives.TopicARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetTopicAttributesRequest(topicArn: TopicARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.GetTopicAttributesRequest = {
    import GetTopicAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.GetTopicAttributesRequest
      .builder()
      .topicArn(TopicARN.unwrap(topicArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.GetTopicAttributesRequest.ReadOnly =
    zio.aws.sns.model.GetTopicAttributesRequest.wrap(buildAwsValue())
}
object GetTopicAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.GetTopicAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.GetTopicAttributesRequest =
      zio.aws.sns.model.GetTopicAttributesRequest(topicArn)
    def topicArn: TopicARN
    def getTopicArn: ZIO[Any, Nothing, TopicARN] = ZIO.succeed(topicArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.GetTopicAttributesRequest
  ) extends zio.aws.sns.model.GetTopicAttributesRequest.ReadOnly {
    override val topicArn: TopicARN =
      zio.aws.sns.model.primitives.TopicARN(impl.topicArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.GetTopicAttributesRequest
  ): zio.aws.sns.model.GetTopicAttributesRequest.ReadOnly = new Wrapper(impl)
}
