package zio.aws.sns.model
import scala.jdk.CollectionConverters._
sealed trait LanguageCodeString {
  def unwrap: software.amazon.awssdk.services.sns.model.LanguageCodeString
}
object LanguageCodeString {
  def wrap(
      value: software.amazon.awssdk.services.sns.model.LanguageCodeString
  ): zio.aws.sns.model.LanguageCodeString = value match {
    case software.amazon.awssdk.services.sns.model.LanguageCodeString.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sns.model.LanguageCodeString.EN_US =>
      val r = `en-US`
      r
    case software.amazon.awssdk.services.sns.model.LanguageCodeString.EN_GB =>
      val r = `en-GB`
      r
    case software.amazon.awssdk.services.sns.model.LanguageCodeString.ES_419 =>
      val r = `es-419`
      r
    case software.amazon.awssdk.services.sns.model.LanguageCodeString.ES_ES =>
      val r = `es-ES`
      r
    case software.amazon.awssdk.services.sns.model.LanguageCodeString.DE_DE =>
      val r = `de-DE`
      r
    case software.amazon.awssdk.services.sns.model.LanguageCodeString.FR_CA =>
      val r = `fr-CA`
      r
    case software.amazon.awssdk.services.sns.model.LanguageCodeString.FR_FR =>
      val r = `fr-FR`
      r
    case software.amazon.awssdk.services.sns.model.LanguageCodeString.IT_IT =>
      val r = `it-IT`
      r
    case software.amazon.awssdk.services.sns.model.LanguageCodeString.JA_JP =>
      val r = `ja-JP`
      r
    case software.amazon.awssdk.services.sns.model.LanguageCodeString.PT_BR =>
      val r = `pt-BR`
      r
    case software.amazon.awssdk.services.sns.model.LanguageCodeString.KR_KR =>
      val r = `kr-KR`
      r
    case software.amazon.awssdk.services.sns.model.LanguageCodeString.ZH_CN =>
      val r = `zh-CN`
      r
    case software.amazon.awssdk.services.sns.model.LanguageCodeString.ZH_TW =>
      val r = `zh-TW`
      r
  }
  case object unknownToSdkVersion extends zio.aws.sns.model.LanguageCodeString {
    override def unwrap
        : software.amazon.awssdk.services.sns.model.LanguageCodeString =
      software.amazon.awssdk.services.sns.model.LanguageCodeString.UNKNOWN_TO_SDK_VERSION
  }
  case object `en-US` extends zio.aws.sns.model.LanguageCodeString {
    override def unwrap
        : software.amazon.awssdk.services.sns.model.LanguageCodeString =
      software.amazon.awssdk.services.sns.model.LanguageCodeString.EN_US
  }
  case object `en-GB` extends zio.aws.sns.model.LanguageCodeString {
    override def unwrap
        : software.amazon.awssdk.services.sns.model.LanguageCodeString =
      software.amazon.awssdk.services.sns.model.LanguageCodeString.EN_GB
  }
  case object `es-419` extends zio.aws.sns.model.LanguageCodeString {
    override def unwrap
        : software.amazon.awssdk.services.sns.model.LanguageCodeString =
      software.amazon.awssdk.services.sns.model.LanguageCodeString.ES_419
  }
  case object `es-ES` extends zio.aws.sns.model.LanguageCodeString {
    override def unwrap
        : software.amazon.awssdk.services.sns.model.LanguageCodeString =
      software.amazon.awssdk.services.sns.model.LanguageCodeString.ES_ES
  }
  case object `de-DE` extends zio.aws.sns.model.LanguageCodeString {
    override def unwrap
        : software.amazon.awssdk.services.sns.model.LanguageCodeString =
      software.amazon.awssdk.services.sns.model.LanguageCodeString.DE_DE
  }
  case object `fr-CA` extends zio.aws.sns.model.LanguageCodeString {
    override def unwrap
        : software.amazon.awssdk.services.sns.model.LanguageCodeString =
      software.amazon.awssdk.services.sns.model.LanguageCodeString.FR_CA
  }
  case object `fr-FR` extends zio.aws.sns.model.LanguageCodeString {
    override def unwrap
        : software.amazon.awssdk.services.sns.model.LanguageCodeString =
      software.amazon.awssdk.services.sns.model.LanguageCodeString.FR_FR
  }
  case object `it-IT` extends zio.aws.sns.model.LanguageCodeString {
    override def unwrap
        : software.amazon.awssdk.services.sns.model.LanguageCodeString =
      software.amazon.awssdk.services.sns.model.LanguageCodeString.IT_IT
  }
  case object `ja-JP` extends zio.aws.sns.model.LanguageCodeString {
    override def unwrap
        : software.amazon.awssdk.services.sns.model.LanguageCodeString =
      software.amazon.awssdk.services.sns.model.LanguageCodeString.JA_JP
  }
  case object `pt-BR` extends zio.aws.sns.model.LanguageCodeString {
    override def unwrap
        : software.amazon.awssdk.services.sns.model.LanguageCodeString =
      software.amazon.awssdk.services.sns.model.LanguageCodeString.PT_BR
  }
  case object `kr-KR` extends zio.aws.sns.model.LanguageCodeString {
    override def unwrap
        : software.amazon.awssdk.services.sns.model.LanguageCodeString =
      software.amazon.awssdk.services.sns.model.LanguageCodeString.KR_KR
  }
  case object `zh-CN` extends zio.aws.sns.model.LanguageCodeString {
    override def unwrap
        : software.amazon.awssdk.services.sns.model.LanguageCodeString =
      software.amazon.awssdk.services.sns.model.LanguageCodeString.ZH_CN
  }
  case object `zh-TW` extends zio.aws.sns.model.LanguageCodeString {
    override def unwrap
        : software.amazon.awssdk.services.sns.model.LanguageCodeString =
      software.amazon.awssdk.services.sns.model.LanguageCodeString.ZH_TW
  }
}
