package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListEndpointsByPlatformApplicationRequest(
    platformApplicationArn: String,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationRequest = {
    import ListEndpointsByPlatformApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationRequest
      .builder()
      .platformApplicationArn(platformApplicationArn: java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sns.model.ListEndpointsByPlatformApplicationRequest.ReadOnly =
    zio.aws.sns.model.ListEndpointsByPlatformApplicationRequest
      .wrap(buildAwsValue())
}
object ListEndpointsByPlatformApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sns.model.ListEndpointsByPlatformApplicationRequest =
      zio.aws.sns.model.ListEndpointsByPlatformApplicationRequest(
        platformApplicationArn,
        nextToken.map(value => value)
      )
    def platformApplicationArn: String
    def nextToken: Optional[String]
    def getPlatformApplicationArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(platformApplicationArn)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationRequest
  ) extends zio.aws.sns.model.ListEndpointsByPlatformApplicationRequest.ReadOnly {
    override val platformApplicationArn: String =
      impl.platformApplicationArn(): String
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationRequest
  ): zio.aws.sns.model.ListEndpointsByPlatformApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
