package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListEndpointsByPlatformApplicationResponse(
    endpoints: Optional[Iterable[zio.aws.sns.model.Endpoint]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationResponse = {
    import ListEndpointsByPlatformApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationResponse
      .builder()
      .optionallyWith(
        endpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpoints)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sns.model.ListEndpointsByPlatformApplicationResponse.ReadOnly =
    zio.aws.sns.model.ListEndpointsByPlatformApplicationResponse
      .wrap(buildAwsValue())
}
object ListEndpointsByPlatformApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sns.model.ListEndpointsByPlatformApplicationResponse =
      zio.aws.sns.model.ListEndpointsByPlatformApplicationResponse(
        endpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def endpoints: Optional[List[zio.aws.sns.model.Endpoint.ReadOnly]]
    def nextToken: Optional[String]
    def getEndpoints
        : ZIO[Any, AwsError, List[zio.aws.sns.model.Endpoint.ReadOnly]] =
      AwsError.unwrapOptionField("endpoints", endpoints)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationResponse
  ) extends zio.aws.sns.model.ListEndpointsByPlatformApplicationResponse.ReadOnly {
    override val endpoints
        : Optional[List[zio.aws.sns.model.Endpoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sns.model.Endpoint.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationResponse
  ): zio.aws.sns.model.ListEndpointsByPlatformApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
