package zio.aws.sns.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sns.model.primitives.{MaxItemsListOriginationNumbers, NextToken}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListOriginationNumbersRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxItemsListOriginationNumbers] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.ListOriginationNumbersRequest = {
    import ListOriginationNumbersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.ListOriginationNumbersRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          MaxItemsListOriginationNumbers.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.ListOriginationNumbersRequest.ReadOnly =
    zio.aws.sns.model.ListOriginationNumbersRequest.wrap(buildAwsValue())
}
object ListOriginationNumbersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.ListOriginationNumbersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.ListOriginationNumbersRequest =
      zio.aws.sns.model.ListOriginationNumbersRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxItemsListOriginationNumbers]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxItemsListOriginationNumbers] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.ListOriginationNumbersRequest
  ) extends zio.aws.sns.model.ListOriginationNumbersRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sns.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxItemsListOriginationNumbers] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.sns.model.primitives.MaxItemsListOriginationNumbers(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.ListOriginationNumbersRequest
  ): zio.aws.sns.model.ListOriginationNumbersRequest.ReadOnly = new Wrapper(
    impl
  )
}
