package zio.aws.sns.model
import zio.aws.sns.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListOriginationNumbersResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    phoneNumbers: Optional[Iterable[zio.aws.sns.model.PhoneNumberInformation]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.ListOriginationNumbersResponse = {
    import ListOriginationNumbersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.ListOriginationNumbersResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        phoneNumbers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phoneNumbers)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.ListOriginationNumbersResponse.ReadOnly =
    zio.aws.sns.model.ListOriginationNumbersResponse.wrap(buildAwsValue())
}
object ListOriginationNumbersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.ListOriginationNumbersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.ListOriginationNumbersResponse =
      zio.aws.sns.model.ListOriginationNumbersResponse(
        nextToken.map(value => value),
        phoneNumbers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def phoneNumbers
        : Optional[List[zio.aws.sns.model.PhoneNumberInformation.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPhoneNumbers: ZIO[Any, AwsError, List[
      zio.aws.sns.model.PhoneNumberInformation.ReadOnly
    ]] = AwsError.unwrapOptionField("phoneNumbers", phoneNumbers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.ListOriginationNumbersResponse
  ) extends zio.aws.sns.model.ListOriginationNumbersResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sns.model.primitives.NextToken(value))
    override val phoneNumbers
        : Optional[List[zio.aws.sns.model.PhoneNumberInformation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumbers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sns.model.PhoneNumberInformation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.ListOriginationNumbersResponse
  ): zio.aws.sns.model.ListOriginationNumbersResponse.ReadOnly = new Wrapper(
    impl
  )
}
