package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPhoneNumbersOptedOutRequest(
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutRequest = {
    import ListPhoneNumbersOptedOutRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.sns.model.ListPhoneNumbersOptedOutRequest.ReadOnly =
    zio.aws.sns.model.ListPhoneNumbersOptedOutRequest.wrap(buildAwsValue())
}
object ListPhoneNumbersOptedOutRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.ListPhoneNumbersOptedOutRequest =
      zio.aws.sns.model
        .ListPhoneNumbersOptedOutRequest(nextToken.map(value => value))
    def nextToken: Optional[String]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutRequest
  ) extends zio.aws.sns.model.ListPhoneNumbersOptedOutRequest.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutRequest
  ): zio.aws.sns.model.ListPhoneNumbersOptedOutRequest.ReadOnly = new Wrapper(
    impl
  )
}
