package zio.aws.sns.model
import zio.aws.sns.model.primitives.PhoneNumber
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPhoneNumbersOptedOutResponse(
    phoneNumbers: Optional[Iterable[PhoneNumber]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutResponse = {
    import ListPhoneNumbersOptedOutResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutResponse
      .builder()
      .optionallyWith(
        phoneNumbers.map(value =>
          value.map { item =>
            PhoneNumber.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.phoneNumbers)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.sns.model.ListPhoneNumbersOptedOutResponse.ReadOnly =
    zio.aws.sns.model.ListPhoneNumbersOptedOutResponse.wrap(buildAwsValue())
}
object ListPhoneNumbersOptedOutResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.ListPhoneNumbersOptedOutResponse =
      zio.aws.sns.model.ListPhoneNumbersOptedOutResponse(
        phoneNumbers.map(value => value),
        nextToken.map(value => value)
      )
    def phoneNumbers: Optional[List[PhoneNumber]]
    def nextToken: Optional[String]
    def getPhoneNumbers: ZIO[Any, AwsError, List[PhoneNumber]] =
      AwsError.unwrapOptionField("phoneNumbers", phoneNumbers)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutResponse
  ) extends zio.aws.sns.model.ListPhoneNumbersOptedOutResponse.ReadOnly {
    override val phoneNumbers: Optional[List[PhoneNumber]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumbers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sns.model.primitives.PhoneNumber(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutResponse
  ): zio.aws.sns.model.ListPhoneNumbersOptedOutResponse.ReadOnly = new Wrapper(
    impl
  )
}
