package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPlatformApplicationsRequest(
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest = {
    import ListPlatformApplicationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.sns.model.ListPlatformApplicationsRequest.ReadOnly =
    zio.aws.sns.model.ListPlatformApplicationsRequest.wrap(buildAwsValue())
}
object ListPlatformApplicationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.ListPlatformApplicationsRequest =
      zio.aws.sns.model
        .ListPlatformApplicationsRequest(nextToken.map(value => value))
    def nextToken: Optional[String]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest
  ) extends zio.aws.sns.model.ListPlatformApplicationsRequest.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest
  ): zio.aws.sns.model.ListPlatformApplicationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
