package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPlatformApplicationsResponse(
    platformApplications: Optional[
      Iterable[zio.aws.sns.model.PlatformApplication]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.ListPlatformApplicationsResponse = {
    import ListPlatformApplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.ListPlatformApplicationsResponse
      .builder()
      .optionallyWith(
        platformApplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.platformApplications)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.sns.model.ListPlatformApplicationsResponse.ReadOnly =
    zio.aws.sns.model.ListPlatformApplicationsResponse.wrap(buildAwsValue())
}
object ListPlatformApplicationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.ListPlatformApplicationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.ListPlatformApplicationsResponse =
      zio.aws.sns.model.ListPlatformApplicationsResponse(
        platformApplications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def platformApplications
        : Optional[List[zio.aws.sns.model.PlatformApplication.ReadOnly]]
    def nextToken: Optional[String]
    def getPlatformApplications: ZIO[Any, AwsError, List[
      zio.aws.sns.model.PlatformApplication.ReadOnly
    ]] =
      AwsError.unwrapOptionField("platformApplications", platformApplications)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.ListPlatformApplicationsResponse
  ) extends zio.aws.sns.model.ListPlatformApplicationsResponse.ReadOnly {
    override val platformApplications
        : Optional[List[zio.aws.sns.model.PlatformApplication.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformApplications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sns.model.PlatformApplication.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.ListPlatformApplicationsResponse
  ): zio.aws.sns.model.ListPlatformApplicationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
