package zio.aws.sns.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sns.model.primitives.{MaxItems, NextToken}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSmsSandboxPhoneNumbersRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxItems] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersRequest = {
    import ListSmsSandboxPhoneNumbersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => MaxItems.unwrap(value): Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly: zio.aws.sns.model.ListSmsSandboxPhoneNumbersRequest.ReadOnly =
    zio.aws.sns.model.ListSmsSandboxPhoneNumbersRequest.wrap(buildAwsValue())
}
object ListSmsSandboxPhoneNumbersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.ListSmsSandboxPhoneNumbersRequest =
      zio.aws.sns.model.ListSmsSandboxPhoneNumbersRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxItems]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersRequest
  ) extends zio.aws.sns.model.ListSmsSandboxPhoneNumbersRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sns.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sns.model.primitives.MaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersRequest
  ): zio.aws.sns.model.ListSmsSandboxPhoneNumbersRequest.ReadOnly = new Wrapper(
    impl
  )
}
