package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSmsSandboxPhoneNumbersResponse(
    phoneNumbers: Iterable[zio.aws.sns.model.SMSSandboxPhoneNumber],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersResponse = {
    import ListSmsSandboxPhoneNumbersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersResponse
      .builder()
      .phoneNumbers(phoneNumbers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sns.model.ListSmsSandboxPhoneNumbersResponse.ReadOnly =
    zio.aws.sns.model.ListSmsSandboxPhoneNumbersResponse.wrap(buildAwsValue())
}
object ListSmsSandboxPhoneNumbersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.ListSmsSandboxPhoneNumbersResponse =
      zio.aws.sns.model.ListSmsSandboxPhoneNumbersResponse(
        phoneNumbers.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def phoneNumbers: List[zio.aws.sns.model.SMSSandboxPhoneNumber.ReadOnly]
    def nextToken: Optional[String]
    def getPhoneNumbers: ZIO[Any, Nothing, List[
      zio.aws.sns.model.SMSSandboxPhoneNumber.ReadOnly
    ]] = ZIO.succeed(phoneNumbers)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersResponse
  ) extends zio.aws.sns.model.ListSmsSandboxPhoneNumbersResponse.ReadOnly {
    override val phoneNumbers
        : List[zio.aws.sns.model.SMSSandboxPhoneNumber.ReadOnly] = impl
      .phoneNumbers()
      .asScala
      .map { item =>
        zio.aws.sns.model.SMSSandboxPhoneNumber.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersResponse
  ): zio.aws.sns.model.ListSmsSandboxPhoneNumbersResponse.ReadOnly =
    new Wrapper(impl)
}
