package zio.aws.sns.model
import zio.aws.sns.model.primitives.{NextToken, TopicARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSubscriptionsByTopicRequest(
    topicArn: TopicARN,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest = {
    import ListSubscriptionsByTopicRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest
      .builder()
      .topicArn(TopicARN.unwrap(topicArn): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.ListSubscriptionsByTopicRequest.ReadOnly =
    zio.aws.sns.model.ListSubscriptionsByTopicRequest.wrap(buildAwsValue())
}
object ListSubscriptionsByTopicRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.ListSubscriptionsByTopicRequest =
      zio.aws.sns.model.ListSubscriptionsByTopicRequest(
        topicArn,
        nextToken.map(value => value)
      )
    def topicArn: TopicARN
    def nextToken: Optional[NextToken]
    def getTopicArn: ZIO[Any, Nothing, TopicARN] = ZIO.succeed(topicArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest
  ) extends zio.aws.sns.model.ListSubscriptionsByTopicRequest.ReadOnly {
    override val topicArn: TopicARN =
      zio.aws.sns.model.primitives.TopicARN(impl.topicArn())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sns.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest
  ): zio.aws.sns.model.ListSubscriptionsByTopicRequest.ReadOnly = new Wrapper(
    impl
  )
}
