package zio.aws.sns.model
import zio.aws.sns.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSubscriptionsByTopicResponse(
    subscriptions: Optional[Iterable[zio.aws.sns.model.Subscription]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicResponse = {
    import ListSubscriptionsByTopicResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicResponse
      .builder()
      .optionallyWith(
        subscriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subscriptions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.ListSubscriptionsByTopicResponse.ReadOnly =
    zio.aws.sns.model.ListSubscriptionsByTopicResponse.wrap(buildAwsValue())
}
object ListSubscriptionsByTopicResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.ListSubscriptionsByTopicResponse =
      zio.aws.sns.model.ListSubscriptionsByTopicResponse(
        subscriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def subscriptions: Optional[List[zio.aws.sns.model.Subscription.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getSubscriptions
        : ZIO[Any, AwsError, List[zio.aws.sns.model.Subscription.ReadOnly]] =
      AwsError.unwrapOptionField("subscriptions", subscriptions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicResponse
  ) extends zio.aws.sns.model.ListSubscriptionsByTopicResponse.ReadOnly {
    override val subscriptions
        : Optional[List[zio.aws.sns.model.Subscription.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sns.model.Subscription.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sns.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicResponse
  ): zio.aws.sns.model.ListSubscriptionsByTopicResponse.ReadOnly = new Wrapper(
    impl
  )
}
