package zio.aws.sns.model
import zio.aws.sns.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSubscriptionsRequest(
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest = {
    import ListSubscriptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.ListSubscriptionsRequest.ReadOnly =
    zio.aws.sns.model.ListSubscriptionsRequest.wrap(buildAwsValue())
}
object ListSubscriptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.ListSubscriptionsRequest =
      zio.aws.sns.model.ListSubscriptionsRequest(nextToken.map(value => value))
    def nextToken: Optional[NextToken]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest
  ) extends zio.aws.sns.model.ListSubscriptionsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sns.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest
  ): zio.aws.sns.model.ListSubscriptionsRequest.ReadOnly = new Wrapper(impl)
}
