package zio.aws.sns.model
import zio.aws.sns.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTopicsRequest(
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.ListTopicsRequest = {
    import ListTopicsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.ListTopicsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.ListTopicsRequest.ReadOnly =
    zio.aws.sns.model.ListTopicsRequest.wrap(buildAwsValue())
}
object ListTopicsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.ListTopicsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.ListTopicsRequest =
      zio.aws.sns.model.ListTopicsRequest(nextToken.map(value => value))
    def nextToken: Optional[NextToken]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.ListTopicsRequest
  ) extends zio.aws.sns.model.ListTopicsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sns.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.ListTopicsRequest
  ): zio.aws.sns.model.ListTopicsRequest.ReadOnly = new Wrapper(impl)
}
