package zio.aws.sns.model
import zio.aws.sns.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTopicsResponse(
    topics: Optional[Iterable[zio.aws.sns.model.Topic]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.ListTopicsResponse = {
    import ListTopicsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.ListTopicsResponse
      .builder()
      .optionallyWith(
        topics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.topics)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.ListTopicsResponse.ReadOnly =
    zio.aws.sns.model.ListTopicsResponse.wrap(buildAwsValue())
}
object ListTopicsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.ListTopicsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.ListTopicsResponse =
      zio.aws.sns.model.ListTopicsResponse(
        topics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def topics: Optional[List[zio.aws.sns.model.Topic.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getTopics: ZIO[Any, AwsError, List[zio.aws.sns.model.Topic.ReadOnly]] =
      AwsError.unwrapOptionField("topics", topics)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.ListTopicsResponse
  ) extends zio.aws.sns.model.ListTopicsResponse.ReadOnly {
    override val topics: Optional[List[zio.aws.sns.model.Topic.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.topics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sns.model.Topic.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sns.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.ListTopicsResponse
  ): zio.aws.sns.model.ListTopicsResponse.ReadOnly = new Wrapper(impl)
}
