package zio.aws.sns.model
import zio.aws.sns.model.primitives.Binary
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MessageAttributeValue(
    dataType: String,
    stringValue: Optional[String] = Optional.Absent,
    binaryValue: Optional[Binary] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.MessageAttributeValue = {
    import MessageAttributeValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.MessageAttributeValue
      .builder()
      .dataType(dataType: java.lang.String)
      .optionallyWith(stringValue.map(value => value: java.lang.String))(
        _.stringValue
      )
      .optionallyWith(
        binaryValue.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.binaryValue)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.MessageAttributeValue.ReadOnly =
    zio.aws.sns.model.MessageAttributeValue.wrap(buildAwsValue())
}
object MessageAttributeValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.MessageAttributeValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.MessageAttributeValue =
      zio.aws.sns.model.MessageAttributeValue(
        dataType,
        stringValue.map(value => value),
        binaryValue.map(value => value)
      )
    def dataType: String
    def stringValue: Optional[String]
    def binaryValue: Optional[Binary]
    def getDataType: ZIO[Any, Nothing, String] = ZIO.succeed(dataType)
    def getStringValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stringValue", stringValue)
    def getBinaryValue: ZIO[Any, AwsError, Binary] =
      AwsError.unwrapOptionField("binaryValue", binaryValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.MessageAttributeValue
  ) extends zio.aws.sns.model.MessageAttributeValue.ReadOnly {
    override val dataType: String = impl.dataType(): String
    override val stringValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stringValue())
      .map(value => value: String)
    override val binaryValue: Optional[Binary] = zio.aws.core.internal
      .optionalFromNullable(impl.binaryValue())
      .map(value =>
        zio.aws.sns.model.primitives
          .Binary(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.MessageAttributeValue
  ): zio.aws.sns.model.MessageAttributeValue.ReadOnly = new Wrapper(impl)
}
