package zio.aws.sns.model
import scala.jdk.CollectionConverters._
sealed trait NumberCapability {
  def unwrap: software.amazon.awssdk.services.sns.model.NumberCapability
}
object NumberCapability {
  def wrap(
      value: software.amazon.awssdk.services.sns.model.NumberCapability
  ): zio.aws.sns.model.NumberCapability = value match {
    case software.amazon.awssdk.services.sns.model.NumberCapability.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sns.model.NumberCapability.SMS =>
      val r = SMS
      r
    case software.amazon.awssdk.services.sns.model.NumberCapability.MMS =>
      val r = MMS
      r
    case software.amazon.awssdk.services.sns.model.NumberCapability.VOICE =>
      val r = VOICE
      r
  }
  case object unknownToSdkVersion extends zio.aws.sns.model.NumberCapability {
    override def unwrap
        : software.amazon.awssdk.services.sns.model.NumberCapability =
      software.amazon.awssdk.services.sns.model.NumberCapability.UNKNOWN_TO_SDK_VERSION
  }
  case object SMS extends zio.aws.sns.model.NumberCapability {
    override def unwrap
        : software.amazon.awssdk.services.sns.model.NumberCapability =
      software.amazon.awssdk.services.sns.model.NumberCapability.SMS
  }
  case object MMS extends zio.aws.sns.model.NumberCapability {
    override def unwrap
        : software.amazon.awssdk.services.sns.model.NumberCapability =
      software.amazon.awssdk.services.sns.model.NumberCapability.MMS
  }
  case object VOICE extends zio.aws.sns.model.NumberCapability {
    override def unwrap
        : software.amazon.awssdk.services.sns.model.NumberCapability =
      software.amazon.awssdk.services.sns.model.NumberCapability.VOICE
  }
}
