package zio.aws.sns.model
import zio.aws.sns.model.primitives.PhoneNumber
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class OptInPhoneNumberRequest(phoneNumber: PhoneNumber) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.OptInPhoneNumberRequest = {
    import OptInPhoneNumberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.OptInPhoneNumberRequest
      .builder()
      .phoneNumber(PhoneNumber.unwrap(phoneNumber): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.OptInPhoneNumberRequest.ReadOnly =
    zio.aws.sns.model.OptInPhoneNumberRequest.wrap(buildAwsValue())
}
object OptInPhoneNumberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.OptInPhoneNumberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.OptInPhoneNumberRequest =
      zio.aws.sns.model.OptInPhoneNumberRequest(phoneNumber)
    def phoneNumber: PhoneNumber
    def getPhoneNumber: ZIO[Any, Nothing, PhoneNumber] =
      ZIO.succeed(phoneNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.OptInPhoneNumberRequest
  ) extends zio.aws.sns.model.OptInPhoneNumberRequest.ReadOnly {
    override val phoneNumber: PhoneNumber =
      zio.aws.sns.model.primitives.PhoneNumber(impl.phoneNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.OptInPhoneNumberRequest
  ): zio.aws.sns.model.OptInPhoneNumberRequest.ReadOnly = new Wrapper(impl)
}
