package zio.aws.sns.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sns.model.primitives.{Iso2CountryCode, Timestamp}
import scala.jdk.CollectionConverters._
final case class PhoneNumberInformation(
    createdAt: Optional[Timestamp] = Optional.Absent,
    phoneNumber: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    iso2CountryCode: Optional[Iso2CountryCode] = Optional.Absent,
    routeType: Optional[zio.aws.sns.model.RouteType] = Optional.Absent,
    numberCapabilities: Optional[Iterable[zio.aws.sns.model.NumberCapability]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.PhoneNumberInformation = {
    import PhoneNumberInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.PhoneNumberInformation
      .builder()
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(phoneNumber.map(value => value: java.lang.String))(
        _.phoneNumber
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        iso2CountryCode.map(value =>
          Iso2CountryCode.unwrap(value): java.lang.String
        )
      )(_.iso2CountryCode)
      .optionallyWith(routeType.map(value => value.unwrap))(_.routeType)
      .optionallyWith(
        numberCapabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.numberCapabilitiesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.PhoneNumberInformation.ReadOnly =
    zio.aws.sns.model.PhoneNumberInformation.wrap(buildAwsValue())
}
object PhoneNumberInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.PhoneNumberInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.PhoneNumberInformation =
      zio.aws.sns.model.PhoneNumberInformation(
        createdAt.map(value => value),
        phoneNumber.map(value => value),
        status.map(value => value),
        iso2CountryCode.map(value => value),
        routeType.map(value => value),
        numberCapabilities.map(value => value)
      )
    def createdAt: Optional[Timestamp]
    def phoneNumber: Optional[String]
    def status: Optional[String]
    def iso2CountryCode: Optional[Iso2CountryCode]
    def routeType: Optional[zio.aws.sns.model.RouteType]
    def numberCapabilities: Optional[List[zio.aws.sns.model.NumberCapability]]
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getPhoneNumber: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("phoneNumber", phoneNumber)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getIso2CountryCode: ZIO[Any, AwsError, Iso2CountryCode] =
      AwsError.unwrapOptionField("iso2CountryCode", iso2CountryCode)
    def getRouteType: ZIO[Any, AwsError, zio.aws.sns.model.RouteType] =
      AwsError.unwrapOptionField("routeType", routeType)
    def getNumberCapabilities
        : ZIO[Any, AwsError, List[zio.aws.sns.model.NumberCapability]] =
      AwsError.unwrapOptionField("numberCapabilities", numberCapabilities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.PhoneNumberInformation
  ) extends zio.aws.sns.model.PhoneNumberInformation.ReadOnly {
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.sns.model.primitives.Timestamp(value))
    override val phoneNumber: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumber())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val iso2CountryCode: Optional[Iso2CountryCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iso2CountryCode())
        .map(value => zio.aws.sns.model.primitives.Iso2CountryCode(value))
    override val routeType: Optional[zio.aws.sns.model.RouteType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routeType())
        .map(value => zio.aws.sns.model.RouteType.wrap(value))
    override val numberCapabilities
        : Optional[List[zio.aws.sns.model.NumberCapability]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberCapabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sns.model.NumberCapability.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.PhoneNumberInformation
  ): zio.aws.sns.model.PhoneNumberInformation.ReadOnly = new Wrapper(impl)
}
