package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PlatformApplication(
    platformApplicationArn: Optional[String] = Optional.Absent,
    attributes: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.PlatformApplication = {
    import PlatformApplication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.PlatformApplication
      .builder()
      .optionallyWith(
        platformApplicationArn.map(value => value: java.lang.String)
      )(_.platformApplicationArn)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.PlatformApplication.ReadOnly =
    zio.aws.sns.model.PlatformApplication.wrap(buildAwsValue())
}
object PlatformApplication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.PlatformApplication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.PlatformApplication =
      zio.aws.sns.model.PlatformApplication(
        platformApplicationArn.map(value => value),
        attributes.map(value => value)
      )
    def platformApplicationArn: Optional[String]
    def attributes: Optional[Map[String, String]]
    def getPlatformApplicationArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("platformApplicationArn", platformApplicationArn)
    def getAttributes: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.PlatformApplication
  ) extends zio.aws.sns.model.PlatformApplication.ReadOnly {
    override val platformApplicationArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformApplicationArn())
        .map(value => value: String)
    override val attributes: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.PlatformApplication
  ): zio.aws.sns.model.PlatformApplication.ReadOnly = new Wrapper(impl)
}
