package zio.aws.sns.model
import zio.aws.sns.model.primitives.TopicARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PublishBatchRequest(
    topicArn: TopicARN,
    publishBatchRequestEntries: Iterable[
      zio.aws.sns.model.PublishBatchRequestEntry
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.PublishBatchRequest = {
    import PublishBatchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.PublishBatchRequest
      .builder()
      .topicArn(TopicARN.unwrap(topicArn): java.lang.String)
      .publishBatchRequestEntries(publishBatchRequestEntries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.PublishBatchRequest.ReadOnly =
    zio.aws.sns.model.PublishBatchRequest.wrap(buildAwsValue())
}
object PublishBatchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.PublishBatchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.PublishBatchRequest =
      zio.aws.sns.model.PublishBatchRequest(
        topicArn,
        publishBatchRequestEntries.map { item =>
          item.asEditable
        }
      )
    def topicArn: TopicARN
    def publishBatchRequestEntries
        : List[zio.aws.sns.model.PublishBatchRequestEntry.ReadOnly]
    def getTopicArn: ZIO[Any, Nothing, TopicARN] = ZIO.succeed(topicArn)
    def getPublishBatchRequestEntries: ZIO[Any, Nothing, List[
      zio.aws.sns.model.PublishBatchRequestEntry.ReadOnly
    ]] = ZIO.succeed(publishBatchRequestEntries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.PublishBatchRequest
  ) extends zio.aws.sns.model.PublishBatchRequest.ReadOnly {
    override val topicArn: TopicARN =
      zio.aws.sns.model.primitives.TopicARN(impl.topicArn())
    override val publishBatchRequestEntries
        : List[zio.aws.sns.model.PublishBatchRequestEntry.ReadOnly] = impl
      .publishBatchRequestEntries()
      .asScala
      .map { item =>
        zio.aws.sns.model.PublishBatchRequestEntry.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.PublishBatchRequest
  ): zio.aws.sns.model.PublishBatchRequest.ReadOnly = new Wrapper(impl)
}
