package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PublishBatchResponse(
    successful: Optional[Iterable[zio.aws.sns.model.PublishBatchResultEntry]] =
      Optional.Absent,
    failed: Optional[Iterable[zio.aws.sns.model.BatchResultErrorEntry]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.PublishBatchResponse = {
    import PublishBatchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.PublishBatchResponse
      .builder()
      .optionallyWith(
        successful.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.successful)
      .optionallyWith(
        failed.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failed)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.PublishBatchResponse.ReadOnly =
    zio.aws.sns.model.PublishBatchResponse.wrap(buildAwsValue())
}
object PublishBatchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.PublishBatchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.PublishBatchResponse =
      zio.aws.sns.model.PublishBatchResponse(
        successful.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failed.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def successful
        : Optional[List[zio.aws.sns.model.PublishBatchResultEntry.ReadOnly]]
    def failed: Optional[List[zio.aws.sns.model.BatchResultErrorEntry.ReadOnly]]
    def getSuccessful: ZIO[Any, AwsError, List[
      zio.aws.sns.model.PublishBatchResultEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("successful", successful)
    def getFailed: ZIO[Any, AwsError, List[
      zio.aws.sns.model.BatchResultErrorEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("failed", failed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.PublishBatchResponse
  ) extends zio.aws.sns.model.PublishBatchResponse.ReadOnly {
    override val successful
        : Optional[List[zio.aws.sns.model.PublishBatchResultEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.successful())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sns.model.PublishBatchResultEntry.wrap(item)
          }.toList
        )
    override val failed
        : Optional[List[zio.aws.sns.model.BatchResultErrorEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failed())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sns.model.BatchResultErrorEntry.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.PublishBatchResponse
  ): zio.aws.sns.model.PublishBatchResponse.ReadOnly = new Wrapper(impl)
}
