package zio.aws.sns.model
import zio.aws.sns.model.primitives.MessageId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PublishBatchResultEntry(
    id: Optional[String] = Optional.Absent,
    messageId: Optional[MessageId] = Optional.Absent,
    sequenceNumber: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.PublishBatchResultEntry = {
    import PublishBatchResultEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.PublishBatchResultEntry
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(
        messageId.map(value => MessageId.unwrap(value): java.lang.String)
      )(_.messageId)
      .optionallyWith(sequenceNumber.map(value => value: java.lang.String))(
        _.sequenceNumber
      )
      .build()
  }
  def asReadOnly: zio.aws.sns.model.PublishBatchResultEntry.ReadOnly =
    zio.aws.sns.model.PublishBatchResultEntry.wrap(buildAwsValue())
}
object PublishBatchResultEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.PublishBatchResultEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.PublishBatchResultEntry =
      zio.aws.sns.model.PublishBatchResultEntry(
        id.map(value => value),
        messageId.map(value => value),
        sequenceNumber.map(value => value)
      )
    def id: Optional[String]
    def messageId: Optional[MessageId]
    def sequenceNumber: Optional[String]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getMessageId: ZIO[Any, AwsError, MessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
    def getSequenceNumber: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sequenceNumber", sequenceNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.PublishBatchResultEntry
  ) extends zio.aws.sns.model.PublishBatchResultEntry.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val messageId: Optional[MessageId] = zio.aws.core.internal
      .optionalFromNullable(impl.messageId())
      .map(value => zio.aws.sns.model.primitives.MessageId(value))
    override val sequenceNumber: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sequenceNumber())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.PublishBatchResultEntry
  ): zio.aws.sns.model.PublishBatchResultEntry.ReadOnly = new Wrapper(impl)
}
