package zio.aws.sns.model
import zio.aws.sns.model.primitives.{
  MessageStructure,
  Subject,
  Message,
  TopicARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PublishRequest(
    topicArn: Optional[TopicARN] = Optional.Absent,
    targetArn: Optional[String] = Optional.Absent,
    phoneNumber: Optional[String] = Optional.Absent,
    message: Message,
    subject: Optional[Subject] = Optional.Absent,
    messageStructure: Optional[MessageStructure] = Optional.Absent,
    messageAttributes: Optional[
      Map[String, zio.aws.sns.model.MessageAttributeValue]
    ] = Optional.Absent,
    messageDeduplicationId: Optional[String] = Optional.Absent,
    messageGroupId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.PublishRequest = {
    import PublishRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.PublishRequest
      .builder()
      .optionallyWith(
        topicArn.map(value => TopicARN.unwrap(value): java.lang.String)
      )(_.topicArn)
      .optionallyWith(targetArn.map(value => value: java.lang.String))(
        _.targetArn
      )
      .optionallyWith(phoneNumber.map(value => value: java.lang.String))(
        _.phoneNumber
      )
      .message(Message.unwrap(message): java.lang.String)
      .optionallyWith(
        subject.map(value => Subject.unwrap(value): java.lang.String)
      )(_.subject)
      .optionallyWith(
        messageStructure.map(value =>
          MessageStructure.unwrap(value): java.lang.String
        )
      )(_.messageStructure)
      .optionallyWith(
        messageAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.messageAttributes)
      .optionallyWith(
        messageDeduplicationId.map(value => value: java.lang.String)
      )(_.messageDeduplicationId)
      .optionallyWith(messageGroupId.map(value => value: java.lang.String))(
        _.messageGroupId
      )
      .build()
  }
  def asReadOnly: zio.aws.sns.model.PublishRequest.ReadOnly =
    zio.aws.sns.model.PublishRequest.wrap(buildAwsValue())
}
object PublishRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.PublishRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.PublishRequest =
      zio.aws.sns.model.PublishRequest(
        topicArn.map(value => value),
        targetArn.map(value => value),
        phoneNumber.map(value => value),
        message,
        subject.map(value => value),
        messageStructure.map(value => value),
        messageAttributes.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        messageDeduplicationId.map(value => value),
        messageGroupId.map(value => value)
      )
    def topicArn: Optional[TopicARN]
    def targetArn: Optional[String]
    def phoneNumber: Optional[String]
    def message: Message
    def subject: Optional[Subject]
    def messageStructure: Optional[MessageStructure]
    def messageAttributes: Optional[
      Map[String, zio.aws.sns.model.MessageAttributeValue.ReadOnly]
    ]
    def messageDeduplicationId: Optional[String]
    def messageGroupId: Optional[String]
    def getTopicArn: ZIO[Any, AwsError, TopicARN] =
      AwsError.unwrapOptionField("topicArn", topicArn)
    def getTargetArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetArn", targetArn)
    def getPhoneNumber: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("phoneNumber", phoneNumber)
    def getMessage: ZIO[Any, Nothing, Message] = ZIO.succeed(message)
    def getSubject: ZIO[Any, AwsError, Subject] =
      AwsError.unwrapOptionField("subject", subject)
    def getMessageStructure: ZIO[Any, AwsError, MessageStructure] =
      AwsError.unwrapOptionField("messageStructure", messageStructure)
    def getMessageAttributes: ZIO[Any, AwsError, Map[
      String,
      zio.aws.sns.model.MessageAttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("messageAttributes", messageAttributes)
    def getMessageDeduplicationId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("messageDeduplicationId", messageDeduplicationId)
    def getMessageGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("messageGroupId", messageGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.PublishRequest
  ) extends zio.aws.sns.model.PublishRequest.ReadOnly {
    override val topicArn: Optional[TopicARN] = zio.aws.core.internal
      .optionalFromNullable(impl.topicArn())
      .map(value => zio.aws.sns.model.primitives.TopicARN(value))
    override val targetArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetArn())
      .map(value => value: String)
    override val phoneNumber: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumber())
      .map(value => value: String)
    override val message: Message =
      zio.aws.sns.model.primitives.Message(impl.message())
    override val subject: Optional[Subject] = zio.aws.core.internal
      .optionalFromNullable(impl.subject())
      .map(value => zio.aws.sns.model.primitives.Subject(value))
    override val messageStructure: Optional[MessageStructure] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageStructure())
        .map(value => zio.aws.sns.model.primitives.MessageStructure(value))
    override val messageAttributes: Optional[
      Map[String, zio.aws.sns.model.MessageAttributeValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.messageAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.sns.model.MessageAttributeValue.wrap(value)
          })
          .toMap
      )
    override val messageDeduplicationId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageDeduplicationId())
        .map(value => value: String)
    override val messageGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.messageGroupId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.PublishRequest
  ): zio.aws.sns.model.PublishRequest.ReadOnly = new Wrapper(impl)
}
