package zio.aws.sns.model
import zio.aws.sns.model.primitives.MessageId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PublishResponse(
    messageId: Optional[MessageId] = Optional.Absent,
    sequenceNumber: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.PublishResponse = {
    import PublishResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.PublishResponse
      .builder()
      .optionallyWith(
        messageId.map(value => MessageId.unwrap(value): java.lang.String)
      )(_.messageId)
      .optionallyWith(sequenceNumber.map(value => value: java.lang.String))(
        _.sequenceNumber
      )
      .build()
  }
  def asReadOnly: zio.aws.sns.model.PublishResponse.ReadOnly =
    zio.aws.sns.model.PublishResponse.wrap(buildAwsValue())
}
object PublishResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.PublishResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.PublishResponse =
      zio.aws.sns.model.PublishResponse(
        messageId.map(value => value),
        sequenceNumber.map(value => value)
      )
    def messageId: Optional[MessageId]
    def sequenceNumber: Optional[String]
    def getMessageId: ZIO[Any, AwsError, MessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
    def getSequenceNumber: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sequenceNumber", sequenceNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.PublishResponse
  ) extends zio.aws.sns.model.PublishResponse.ReadOnly {
    override val messageId: Optional[MessageId] = zio.aws.core.internal
      .optionalFromNullable(impl.messageId())
      .map(value => zio.aws.sns.model.primitives.MessageId(value))
    override val sequenceNumber: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sequenceNumber())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.PublishResponse
  ): zio.aws.sns.model.PublishResponse.ReadOnly = new Wrapper(impl)
}
