package zio.aws.sns.model
import zio.aws.sns.model.primitives.{AttributeValue, TopicARN}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutDataProtectionPolicyRequest(
    resourceArn: TopicARN,
    dataProtectionPolicy: AttributeValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.PutDataProtectionPolicyRequest = {
    import PutDataProtectionPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.PutDataProtectionPolicyRequest
      .builder()
      .resourceArn(TopicARN.unwrap(resourceArn): java.lang.String)
      .dataProtectionPolicy(
        AttributeValue.unwrap(dataProtectionPolicy): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sns.model.PutDataProtectionPolicyRequest.ReadOnly =
    zio.aws.sns.model.PutDataProtectionPolicyRequest.wrap(buildAwsValue())
}
object PutDataProtectionPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.PutDataProtectionPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.PutDataProtectionPolicyRequest =
      zio.aws.sns.model
        .PutDataProtectionPolicyRequest(resourceArn, dataProtectionPolicy)
    def resourceArn: TopicARN
    def dataProtectionPolicy: AttributeValue
    def getResourceArn: ZIO[Any, Nothing, TopicARN] = ZIO.succeed(resourceArn)
    def getDataProtectionPolicy: ZIO[Any, Nothing, AttributeValue] =
      ZIO.succeed(dataProtectionPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.PutDataProtectionPolicyRequest
  ) extends zio.aws.sns.model.PutDataProtectionPolicyRequest.ReadOnly {
    override val resourceArn: TopicARN =
      zio.aws.sns.model.primitives.TopicARN(impl.resourceArn())
    override val dataProtectionPolicy: AttributeValue =
      zio.aws.sns.model.primitives.AttributeValue(impl.dataProtectionPolicy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.PutDataProtectionPolicyRequest
  ): zio.aws.sns.model.PutDataProtectionPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
