package zio.aws.sns.model
import zio.aws.sns.model.primitives.{Label, TopicARN}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RemovePermissionRequest(topicArn: TopicARN, label: Label) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.RemovePermissionRequest = {
    import RemovePermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.RemovePermissionRequest
      .builder()
      .topicArn(TopicARN.unwrap(topicArn): java.lang.String)
      .label(Label.unwrap(label): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.RemovePermissionRequest.ReadOnly =
    zio.aws.sns.model.RemovePermissionRequest.wrap(buildAwsValue())
}
object RemovePermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.RemovePermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.RemovePermissionRequest =
      zio.aws.sns.model.RemovePermissionRequest(topicArn, label)
    def topicArn: TopicARN
    def label: Label
    def getTopicArn: ZIO[Any, Nothing, TopicARN] = ZIO.succeed(topicArn)
    def getLabel: ZIO[Any, Nothing, Label] = ZIO.succeed(label)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.RemovePermissionRequest
  ) extends zio.aws.sns.model.RemovePermissionRequest.ReadOnly {
    override val topicArn: TopicARN =
      zio.aws.sns.model.primitives.TopicARN(impl.topicArn())
    override val label: Label = zio.aws.sns.model.primitives.Label(impl.label())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.RemovePermissionRequest
  ): zio.aws.sns.model.RemovePermissionRequest.ReadOnly = new Wrapper(impl)
}
