package zio.aws.sns.model
import scala.jdk.CollectionConverters._
sealed trait RouteType {
  def unwrap: software.amazon.awssdk.services.sns.model.RouteType
}
object RouteType {
  def wrap(
      value: software.amazon.awssdk.services.sns.model.RouteType
  ): zio.aws.sns.model.RouteType = value match {
    case software.amazon.awssdk.services.sns.model.RouteType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sns.model.RouteType.TRANSACTIONAL =>
      val r = Transactional
      r
    case software.amazon.awssdk.services.sns.model.RouteType.PROMOTIONAL =>
      val r = Promotional
      r
    case software.amazon.awssdk.services.sns.model.RouteType.PREMIUM =>
      val r = Premium
      r
  }
  case object unknownToSdkVersion extends zio.aws.sns.model.RouteType {
    override def unwrap: software.amazon.awssdk.services.sns.model.RouteType =
      software.amazon.awssdk.services.sns.model.RouteType.UNKNOWN_TO_SDK_VERSION
  }
  case object Transactional extends zio.aws.sns.model.RouteType {
    override def unwrap: software.amazon.awssdk.services.sns.model.RouteType =
      software.amazon.awssdk.services.sns.model.RouteType.TRANSACTIONAL
  }
  case object Promotional extends zio.aws.sns.model.RouteType {
    override def unwrap: software.amazon.awssdk.services.sns.model.RouteType =
      software.amazon.awssdk.services.sns.model.RouteType.PROMOTIONAL
  }
  case object Premium extends zio.aws.sns.model.RouteType {
    override def unwrap: software.amazon.awssdk.services.sns.model.RouteType =
      software.amazon.awssdk.services.sns.model.RouteType.PREMIUM
  }
}
