package zio.aws.sns.model
import zio.aws.sns.model.primitives.PhoneNumberString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SMSSandboxPhoneNumber(
    phoneNumber: Optional[PhoneNumberString] = Optional.Absent,
    status: Optional[
      zio.aws.sns.model.SMSSandboxPhoneNumberVerificationStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.SMSSandboxPhoneNumber = {
    import SMSSandboxPhoneNumber.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.SMSSandboxPhoneNumber
      .builder()
      .optionallyWith(
        phoneNumber.map(value =>
          PhoneNumberString.unwrap(value): java.lang.String
        )
      )(_.phoneNumber)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.SMSSandboxPhoneNumber.ReadOnly =
    zio.aws.sns.model.SMSSandboxPhoneNumber.wrap(buildAwsValue())
}
object SMSSandboxPhoneNumber {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.SMSSandboxPhoneNumber
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.SMSSandboxPhoneNumber =
      zio.aws.sns.model.SMSSandboxPhoneNumber(
        phoneNumber.map(value => value),
        status.map(value => value)
      )
    def phoneNumber: Optional[PhoneNumberString]
    def status
        : Optional[zio.aws.sns.model.SMSSandboxPhoneNumberVerificationStatus]
    def getPhoneNumber: ZIO[Any, AwsError, PhoneNumberString] =
      AwsError.unwrapOptionField("phoneNumber", phoneNumber)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sns.model.SMSSandboxPhoneNumberVerificationStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.SMSSandboxPhoneNumber
  ) extends zio.aws.sns.model.SMSSandboxPhoneNumber.ReadOnly {
    override val phoneNumber: Optional[PhoneNumberString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumber())
        .map(value => zio.aws.sns.model.primitives.PhoneNumberString(value))
    override val status
        : Optional[zio.aws.sns.model.SMSSandboxPhoneNumberVerificationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.sns.model.SMSSandboxPhoneNumberVerificationStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.SMSSandboxPhoneNumber
  ): zio.aws.sns.model.SMSSandboxPhoneNumber.ReadOnly = new Wrapper(impl)
}
