package zio.aws.sns.model
import scala.jdk.CollectionConverters._
sealed trait SMSSandboxPhoneNumberVerificationStatus {
  def unwrap: software.amazon.awssdk.services.sns.model.SMSSandboxPhoneNumberVerificationStatus
}
object SMSSandboxPhoneNumberVerificationStatus {
  def wrap(
      value: software.amazon.awssdk.services.sns.model.SMSSandboxPhoneNumberVerificationStatus
  ): zio.aws.sns.model.SMSSandboxPhoneNumberVerificationStatus = value match {
    case software.amazon.awssdk.services.sns.model.SMSSandboxPhoneNumberVerificationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sns.model.SMSSandboxPhoneNumberVerificationStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.sns.model.SMSSandboxPhoneNumberVerificationStatus.VERIFIED =>
      val r = Verified
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sns.model.SMSSandboxPhoneNumberVerificationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sns.model.SMSSandboxPhoneNumberVerificationStatus =
      software.amazon.awssdk.services.sns.model.SMSSandboxPhoneNumberVerificationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending
      extends zio.aws.sns.model.SMSSandboxPhoneNumberVerificationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sns.model.SMSSandboxPhoneNumberVerificationStatus =
      software.amazon.awssdk.services.sns.model.SMSSandboxPhoneNumberVerificationStatus.PENDING
  }
  case object Verified
      extends zio.aws.sns.model.SMSSandboxPhoneNumberVerificationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sns.model.SMSSandboxPhoneNumberVerificationStatus =
      software.amazon.awssdk.services.sns.model.SMSSandboxPhoneNumberVerificationStatus.VERIFIED
  }
}
