package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SetEndpointAttributesRequest(
    endpointArn: String,
    attributes: Map[String, String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.SetEndpointAttributesRequest = {
    import SetEndpointAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.SetEndpointAttributesRequest
      .builder()
      .endpointArn(endpointArn: java.lang.String)
      .attributes(
        attributes
          .map({ case (key, value) =>
            (key: java.lang.String) -> (value: java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.sns.model.SetEndpointAttributesRequest.ReadOnly =
    zio.aws.sns.model.SetEndpointAttributesRequest.wrap(buildAwsValue())
}
object SetEndpointAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.SetEndpointAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.SetEndpointAttributesRequest =
      zio.aws.sns.model.SetEndpointAttributesRequest(endpointArn, attributes)
    def endpointArn: String
    def attributes: Map[String, String]
    def getEndpointArn: ZIO[Any, Nothing, String] = ZIO.succeed(endpointArn)
    def getAttributes: ZIO[Any, Nothing, Map[String, String]] =
      ZIO.succeed(attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.SetEndpointAttributesRequest
  ) extends zio.aws.sns.model.SetEndpointAttributesRequest.ReadOnly {
    override val endpointArn: String = impl.endpointArn(): String
    override val attributes: Map[String, String] = impl
      .attributes()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> (value: String)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.SetEndpointAttributesRequest
  ): zio.aws.sns.model.SetEndpointAttributesRequest.ReadOnly = new Wrapper(impl)
}
