package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SetPlatformApplicationAttributesRequest(
    platformApplicationArn: String,
    attributes: Map[String, String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.SetPlatformApplicationAttributesRequest = {
    import SetPlatformApplicationAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.SetPlatformApplicationAttributesRequest
      .builder()
      .platformApplicationArn(platformApplicationArn: java.lang.String)
      .attributes(
        attributes
          .map({ case (key, value) =>
            (key: java.lang.String) -> (value: java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sns.model.SetPlatformApplicationAttributesRequest.ReadOnly =
    zio.aws.sns.model.SetPlatformApplicationAttributesRequest
      .wrap(buildAwsValue())
}
object SetPlatformApplicationAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.SetPlatformApplicationAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.SetPlatformApplicationAttributesRequest =
      zio.aws.sns.model.SetPlatformApplicationAttributesRequest(
        platformApplicationArn,
        attributes
      )
    def platformApplicationArn: String
    def attributes: Map[String, String]
    def getPlatformApplicationArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(platformApplicationArn)
    def getAttributes: ZIO[Any, Nothing, Map[String, String]] =
      ZIO.succeed(attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.SetPlatformApplicationAttributesRequest
  ) extends zio.aws.sns.model.SetPlatformApplicationAttributesRequest.ReadOnly {
    override val platformApplicationArn: String =
      impl.platformApplicationArn(): String
    override val attributes: Map[String, String] = impl
      .attributes()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> (value: String)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.SetPlatformApplicationAttributesRequest
  ): zio.aws.sns.model.SetPlatformApplicationAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
