package zio.aws.sns.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SetSmsAttributesRequest(attributes: Map[String, String]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.SetSmsAttributesRequest = {
    import SetSmsAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.SetSmsAttributesRequest
      .builder()
      .attributes(
        attributes
          .map({ case (key, value) =>
            (key: java.lang.String) -> (value: java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.sns.model.SetSmsAttributesRequest.ReadOnly =
    zio.aws.sns.model.SetSmsAttributesRequest.wrap(buildAwsValue())
}
object SetSmsAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.SetSmsAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.SetSmsAttributesRequest =
      zio.aws.sns.model.SetSmsAttributesRequest(attributes)
    def attributes: Map[String, String]
    def getAttributes: ZIO[Any, Nothing, Map[String, String]] =
      ZIO.succeed(attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.SetSmsAttributesRequest
  ) extends zio.aws.sns.model.SetSmsAttributesRequest.ReadOnly {
    override val attributes: Map[String, String] = impl
      .attributes()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> (value: String)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.SetSmsAttributesRequest
  ): zio.aws.sns.model.SetSmsAttributesRequest.ReadOnly = new Wrapper(impl)
}
