package zio.aws.sns.model
import zio.aws.sns.model.primitives.{
  AttributeValue,
  AttributeName,
  SubscriptionARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SetSubscriptionAttributesRequest(
    subscriptionArn: SubscriptionARN,
    attributeName: AttributeName,
    attributeValue: Optional[AttributeValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.SetSubscriptionAttributesRequest = {
    import SetSubscriptionAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.SetSubscriptionAttributesRequest
      .builder()
      .subscriptionArn(
        SubscriptionARN.unwrap(subscriptionArn): java.lang.String
      )
      .attributeName(AttributeName.unwrap(attributeName): java.lang.String)
      .optionallyWith(
        attributeValue.map(value =>
          AttributeValue.unwrap(value): java.lang.String
        )
      )(_.attributeValue)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.SetSubscriptionAttributesRequest.ReadOnly =
    zio.aws.sns.model.SetSubscriptionAttributesRequest.wrap(buildAwsValue())
}
object SetSubscriptionAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.SetSubscriptionAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.SetSubscriptionAttributesRequest =
      zio.aws.sns.model.SetSubscriptionAttributesRequest(
        subscriptionArn,
        attributeName,
        attributeValue.map(value => value)
      )
    def subscriptionArn: SubscriptionARN
    def attributeName: AttributeName
    def attributeValue: Optional[AttributeValue]
    def getSubscriptionArn: ZIO[Any, Nothing, SubscriptionARN] =
      ZIO.succeed(subscriptionArn)
    def getAttributeName: ZIO[Any, Nothing, AttributeName] =
      ZIO.succeed(attributeName)
    def getAttributeValue: ZIO[Any, AwsError, AttributeValue] =
      AwsError.unwrapOptionField("attributeValue", attributeValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.SetSubscriptionAttributesRequest
  ) extends zio.aws.sns.model.SetSubscriptionAttributesRequest.ReadOnly {
    override val subscriptionArn: SubscriptionARN =
      zio.aws.sns.model.primitives.SubscriptionARN(impl.subscriptionArn())
    override val attributeName: AttributeName =
      zio.aws.sns.model.primitives.AttributeName(impl.attributeName())
    override val attributeValue: Optional[AttributeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeValue())
        .map(value => zio.aws.sns.model.primitives.AttributeValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.SetSubscriptionAttributesRequest
  ): zio.aws.sns.model.SetSubscriptionAttributesRequest.ReadOnly = new Wrapper(
    impl
  )
}
