package zio.aws.sns.model
import zio.aws.sns.model.primitives.{AttributeValue, AttributeName, TopicARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SetTopicAttributesRequest(
    topicArn: TopicARN,
    attributeName: AttributeName,
    attributeValue: Optional[AttributeValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.SetTopicAttributesRequest = {
    import SetTopicAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.SetTopicAttributesRequest
      .builder()
      .topicArn(TopicARN.unwrap(topicArn): java.lang.String)
      .attributeName(AttributeName.unwrap(attributeName): java.lang.String)
      .optionallyWith(
        attributeValue.map(value =>
          AttributeValue.unwrap(value): java.lang.String
        )
      )(_.attributeValue)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.SetTopicAttributesRequest.ReadOnly =
    zio.aws.sns.model.SetTopicAttributesRequest.wrap(buildAwsValue())
}
object SetTopicAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.SetTopicAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.SetTopicAttributesRequest =
      zio.aws.sns.model.SetTopicAttributesRequest(
        topicArn,
        attributeName,
        attributeValue.map(value => value)
      )
    def topicArn: TopicARN
    def attributeName: AttributeName
    def attributeValue: Optional[AttributeValue]
    def getTopicArn: ZIO[Any, Nothing, TopicARN] = ZIO.succeed(topicArn)
    def getAttributeName: ZIO[Any, Nothing, AttributeName] =
      ZIO.succeed(attributeName)
    def getAttributeValue: ZIO[Any, AwsError, AttributeValue] =
      AwsError.unwrapOptionField("attributeValue", attributeValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.SetTopicAttributesRequest
  ) extends zio.aws.sns.model.SetTopicAttributesRequest.ReadOnly {
    override val topicArn: TopicARN =
      zio.aws.sns.model.primitives.TopicARN(impl.topicArn())
    override val attributeName: AttributeName =
      zio.aws.sns.model.primitives.AttributeName(impl.attributeName())
    override val attributeValue: Optional[AttributeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeValue())
        .map(value => zio.aws.sns.model.primitives.AttributeValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.SetTopicAttributesRequest
  ): zio.aws.sns.model.SetTopicAttributesRequest.ReadOnly = new Wrapper(impl)
}
