package zio.aws.sns.model
import zio.aws.sns.model.primitives.{
  AttributeName,
  Protocol,
  TopicARN,
  AttributeValue
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SubscribeRequest(
    topicArn: TopicARN,
    protocol: Protocol,
    endpoint: Optional[zio.aws.sns.model.primitives.Endpoint] = Optional.Absent,
    attributes: Optional[Map[AttributeName, AttributeValue]] = Optional.Absent,
    returnSubscriptionArn: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.SubscribeRequest = {
    import SubscribeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.SubscribeRequest
      .builder()
      .topicArn(TopicARN.unwrap(topicArn): java.lang.String)
      .protocol(Protocol.unwrap(protocol): java.lang.String)
      .optionallyWith(
        endpoint.map(value =>
          zio.aws.sns.model.primitives.Endpoint.unwrap(value): java.lang.String
        )
      )(_.endpoint)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(
        returnSubscriptionArn.map(value => value: java.lang.Boolean)
      )(_.returnSubscriptionArn)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.SubscribeRequest.ReadOnly =
    zio.aws.sns.model.SubscribeRequest.wrap(buildAwsValue())
}
object SubscribeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.SubscribeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.SubscribeRequest =
      zio.aws.sns.model.SubscribeRequest(
        topicArn,
        protocol,
        endpoint.map(value => value),
        attributes.map(value => value),
        returnSubscriptionArn.map(value => value)
      )
    def topicArn: TopicARN
    def protocol: Protocol
    def endpoint: Optional[zio.aws.sns.model.primitives.Endpoint]
    def attributes: Optional[Map[AttributeName, AttributeValue]]
    def returnSubscriptionArn: Optional[Boolean]
    def getTopicArn: ZIO[Any, Nothing, TopicARN] = ZIO.succeed(topicArn)
    def getProtocol: ZIO[Any, Nothing, Protocol] = ZIO.succeed(protocol)
    def getEndpoint: ZIO[Any, AwsError, zio.aws.sns.model.primitives.Endpoint] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getAttributes: ZIO[Any, AwsError, Map[AttributeName, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getReturnSubscriptionArn: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnSubscriptionArn", returnSubscriptionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.SubscribeRequest
  ) extends zio.aws.sns.model.SubscribeRequest.ReadOnly {
    override val topicArn: TopicARN =
      zio.aws.sns.model.primitives.TopicARN(impl.topicArn())
    override val protocol: Protocol =
      zio.aws.sns.model.primitives.Protocol(impl.protocol())
    override val endpoint: Optional[zio.aws.sns.model.primitives.Endpoint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoint())
        .map(value => zio.aws.sns.model.primitives.Endpoint(value))
    override val attributes: Optional[Map[AttributeName, AttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sns.model.primitives.AttributeName(
                key
              ) -> zio.aws.sns.model.primitives.AttributeValue(value)
            })
            .toMap
        )
    override val returnSubscriptionArn: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.returnSubscriptionArn())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.SubscribeRequest
  ): zio.aws.sns.model.SubscribeRequest.ReadOnly = new Wrapper(impl)
}
