package zio.aws.sns.model
import zio.aws.sns.model.primitives.SubscriptionARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SubscribeResponse(
    subscriptionArn: Optional[SubscriptionARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.SubscribeResponse = {
    import SubscribeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.SubscribeResponse
      .builder()
      .optionallyWith(
        subscriptionArn.map(value =>
          SubscriptionARN.unwrap(value): java.lang.String
        )
      )(_.subscriptionArn)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.SubscribeResponse.ReadOnly =
    zio.aws.sns.model.SubscribeResponse.wrap(buildAwsValue())
}
object SubscribeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.SubscribeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.SubscribeResponse =
      zio.aws.sns.model.SubscribeResponse(subscriptionArn.map(value => value))
    def subscriptionArn: Optional[SubscriptionARN]
    def getSubscriptionArn: ZIO[Any, AwsError, SubscriptionARN] =
      AwsError.unwrapOptionField("subscriptionArn", subscriptionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.SubscribeResponse
  ) extends zio.aws.sns.model.SubscribeResponse.ReadOnly {
    override val subscriptionArn: Optional[SubscriptionARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriptionArn())
        .map(value => zio.aws.sns.model.primitives.SubscriptionARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.SubscribeResponse
  ): zio.aws.sns.model.SubscribeResponse.ReadOnly = new Wrapper(impl)
}
