package zio.aws.sns.model
import zio.aws.sns.model.primitives.{
  Account,
  Protocol,
  SubscriptionARN,
  TopicARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Subscription(
    subscriptionArn: Optional[SubscriptionARN] = Optional.Absent,
    owner: Optional[Account] = Optional.Absent,
    protocol: Optional[Protocol] = Optional.Absent,
    endpoint: Optional[zio.aws.sns.model.primitives.Endpoint] = Optional.Absent,
    topicArn: Optional[TopicARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.Subscription = {
    import Subscription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.Subscription
      .builder()
      .optionallyWith(
        subscriptionArn.map(value =>
          SubscriptionARN.unwrap(value): java.lang.String
        )
      )(_.subscriptionArn)
      .optionallyWith(
        owner.map(value => Account.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        protocol.map(value => Protocol.unwrap(value): java.lang.String)
      )(_.protocol)
      .optionallyWith(
        endpoint.map(value =>
          zio.aws.sns.model.primitives.Endpoint.unwrap(value): java.lang.String
        )
      )(_.endpoint)
      .optionallyWith(
        topicArn.map(value => TopicARN.unwrap(value): java.lang.String)
      )(_.topicArn)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.Subscription.ReadOnly =
    zio.aws.sns.model.Subscription.wrap(buildAwsValue())
}
object Subscription {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sns.model.Subscription] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.Subscription =
      zio.aws.sns.model.Subscription(
        subscriptionArn.map(value => value),
        owner.map(value => value),
        protocol.map(value => value),
        endpoint.map(value => value),
        topicArn.map(value => value)
      )
    def subscriptionArn: Optional[SubscriptionARN]
    def owner: Optional[Account]
    def protocol: Optional[Protocol]
    def endpoint: Optional[zio.aws.sns.model.primitives.Endpoint]
    def topicArn: Optional[TopicARN]
    def getSubscriptionArn: ZIO[Any, AwsError, SubscriptionARN] =
      AwsError.unwrapOptionField("subscriptionArn", subscriptionArn)
    def getOwner: ZIO[Any, AwsError, Account] =
      AwsError.unwrapOptionField("owner", owner)
    def getProtocol: ZIO[Any, AwsError, Protocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getEndpoint: ZIO[Any, AwsError, zio.aws.sns.model.primitives.Endpoint] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getTopicArn: ZIO[Any, AwsError, TopicARN] =
      AwsError.unwrapOptionField("topicArn", topicArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.Subscription
  ) extends zio.aws.sns.model.Subscription.ReadOnly {
    override val subscriptionArn: Optional[SubscriptionARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriptionArn())
        .map(value => zio.aws.sns.model.primitives.SubscriptionARN(value))
    override val owner: Optional[Account] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => zio.aws.sns.model.primitives.Account(value))
    override val protocol: Optional[Protocol] = zio.aws.core.internal
      .optionalFromNullable(impl.protocol())
      .map(value => zio.aws.sns.model.primitives.Protocol(value))
    override val endpoint: Optional[zio.aws.sns.model.primitives.Endpoint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoint())
        .map(value => zio.aws.sns.model.primitives.Endpoint(value))
    override val topicArn: Optional[TopicARN] = zio.aws.core.internal
      .optionalFromNullable(impl.topicArn())
      .map(value => zio.aws.sns.model.primitives.TopicARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.Subscription
  ): zio.aws.sns.model.Subscription.ReadOnly = new Wrapper(impl)
}
