package zio.aws.sns.model
import zio.aws.sns.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Tag(key: TagKey, value: TagValue) {
  def buildAwsValue(): software.amazon.awssdk.services.sns.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.Tag
      .builder()
      .key(TagKey.unwrap(key): java.lang.String)
      .value(TagValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.Tag.ReadOnly =
    zio.aws.sns.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sns.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.Tag = zio.aws.sns.model.Tag(key, value)
    def key: TagKey
    def value: TagValue
    def getKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, TagValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.Tag
  ) extends zio.aws.sns.model.Tag.ReadOnly {
    override val key: TagKey = zio.aws.sns.model.primitives.TagKey(impl.key())
    override val value: TagValue =
      zio.aws.sns.model.primitives.TagValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.Tag
  ): zio.aws.sns.model.Tag.ReadOnly = new Wrapper(impl)
}
